<?php
/* Template Name: Blog Details */
get_header();

// call custom breadcrumbs
custom_breadcrumbs();

?>

<section class="py-5" id="blogdetails">
  <div class="container">
    <h2 class="details_heading text-center fw-bold">Blog Details</h2>
    <div class="row py-5 blobdetails_row">
      <main class="col-lg-8">
        <div class="container blog_details">
          <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
              <figure class="image_box">
                <?php if (has_post_thumbnail()) : ?>
                  <?php the_post_thumbnail('large', ['class' => 'img-fluid w-100 mb-4']); ?>
                <?php endif; ?>
              </figure>
              <h2 class="mb-4 fw-bold">
                <?php the_title(); ?>
                <a href="#"><i class="fa fa-bookmark-o"></i></a>
              </h2>
              <ul class="list-inline list-separated text-gray-500 mb-3">
                <li class="list-inline-item">
                  <a class="d-flex align-items-center flex-wrap gap-4 text-reset" href="#">
                    <div class="avatar flex-shrink-0 avtar_img">
                      <?php echo get_avatar(get_the_author_meta('ID'), 50, '', '', ['class' => 'img-fluid']); ?>
                    </div>
                    <h5 class="avtar_img_title"> <?php echo get_the_author_meta('display_name'); ?> </h5>
                  </a>
                </li>
                <li class="list-inline-item small"><i class="far fa-clock"></i> <?php echo get_the_date('F j, Y'); ?></li>


              </ul>
              <div class="post-body">
                <?php the_content(); ?>
              </div>

              <!-- Post Navigation -->
              <div class="posts-nav d-flex justify-content-between align-items-stretch flex-column flex-md-row mb-5">
                <?php $prev_post = get_previous_post(); ?>
                <?php if (!empty($prev_post)) : ?>
                  <a class="prev-post text-start d-flex align-items-center" href="<?php echo get_permalink($prev_post->ID); ?>">
                    <div class="icon prev me-3"><i class="fas fa-angle-left"></i></div>
                    <div class="text">
                      <strong class="text-primary">Previous Post</strong>
                      <h6><?php echo get_the_title($prev_post->ID); ?></h6>
                    </div>
                  </a>
                <?php endif; ?>

                <?php $next_post = get_next_post(); ?>
                <?php if (!empty($next_post)) : ?>
                  <a class="next-post text-end d-flex align-items-center justify-content-end" href="<?php echo get_permalink($next_post->ID); ?>">
                    <div class="text">
                      <strong class="text-primary">Next Post</strong>
                      <h6><?php echo get_the_title($next_post->ID); ?></h6>
                    </div>
                    <div class="icon next ms-3"><i class="fas fa-angle-right"></i></div>
                  </a>
                <?php endif; ?>
              </div>

              <!-- Comments Section -->
              <div class="blog-comments mt-5">
                <?php comments_template(); ?>
              </div>

            <?php endwhile;
          else : ?>
            <p class="text-center">No blog details found.</p>
          <?php endif; ?>
        </div>
      </main>

      <!-- Sidebar -->
      <aside class="col-lg-4 col-10 justify-content-center">
        <div class="card mb-5">
          <div class="card-body aside_section">
            <h4 class="mb-3">Latest Posts</h4>
            <?php
            $recent_posts = new WP_Query(array(
              'post_type'      => 'post',
              'posts_per_page' => 3,
              'post_status'    => 'publish'
            ));
            if ($recent_posts->have_posts()) :
              while ($recent_posts->have_posts()) : $recent_posts->the_post(); ?>
                <a class="text-reset mb-3" href="<?php the_permalink(); ?>">
                  <div class="d-flex align-items-center aside_post">
                    <figure>
                      <?php if (has_post_thumbnail()) : ?>
                        <?php the_post_thumbnail('thumbnail', ['class' => 'img-fluid flex-shrink-0']); ?>
                      <?php else : ?>
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/default-placeholder.png" class="img-fluid flex-shrink-0" alt="Default Image">
                      <?php endif; ?>
                    </figure>
                    <div class="ms-3">
                      <p class="mb-2 fw-bold text-gray-700 lh-1 aside_blog_title">
                        <a href="<?php the_permalink(); ?>"> <?php the_title(); ?> </a>
                      </p>
                      <ul class="list-inline list-separated text-gray-500 gap-5 d-flex align-items-center aside_autor_wrap">
                        <li class="list-inline-item small"><i class="fa-solid fa-user-tie"></i>
                          <span><?php echo get_the_author_meta('display_name'); ?></span>
                        </li>
                        <li class="list-inline-item small"><i class="fa-solid fa-calendar-days"></i>
                          <span><?php echo get_the_date('d-m-Y'); ?></span>
                        </li>
                      </ul>
                    </div>
                  </div>
                </a>
              <?php endwhile;
              wp_reset_postdata();
            else : ?>
              <p class="text-center">No recent posts available.</p>
            <?php endif; ?>
          </div>
        </div>
      </aside>
    </div>
  </div>
</section>


<?php get_footer(); ?>