<?php get_header(); ?>
<?php
// call custom breadcrumbs
custom_breadcrumbs();
?>
<?php

$images = get_post_meta(get_the_ID(), 'feature_tool_images', true);
$images = (!empty($images) && is_array($images)) ? array_slice($images, -6) : []; // Ensure it's an array and limit to last 6
$rating = get_post_meta(get_the_ID(), 'feature_tool_rating', true);
$votes_percent = get_post_meta(get_the_ID(), 'feature_tool_votes_percent', true);
$votes = get_post_meta(get_the_ID(), 'feature_tool_votes', true);
?>

<section id="detailsSlide" class="my-5">
  <div class="container">
    <div class="card details_card p-4">
      <div class="row align-items-center">
        <div class="col-md-7">
          <div class="row align-items-center justify-content-sm-center product_detail_slideimg">
            <div class="col-3 col-sm-3 col-lg-2 slide_image_group">
              <ul class="preview-thumbnail nav nav-tabs d-flex flex-column gap-2 justify-content-center" role="tablist">
                <?php if (!empty($images)) : ?>
                  <?php foreach ($images as $index => $image) : ?>
                    <li class="nav-item">
                      <a class="nav-link <?php echo $index === 0 ? 'active' : ''; ?>"
                        data-bs-target="#pic-<?php echo $index + 1; ?>"
                        data-bs-toggle="tab"
                        role="tab"
                        aria-controls="pic-<?php echo $index + 1; ?>"
                        aria-selected="<?php echo $index === 0 ? 'true' : 'false'; ?>"
                        id="tab<?php echo $index + 1; ?>">
                        <img src="<?php echo esc_url($image); ?>" alt="Thumbnail <?php echo $index + 1; ?>" />
                      </a>
                    </li>
                  <?php endforeach; ?>
                <?php else : ?>
                  <li>No images available.</li>
                <?php endif; ?>
              </ul>
            </div>
            <div class="col-9 col-lg-9">
              <div class="preview-pic tab-content">
                <?php if (!empty($images)) : ?>
                  <?php foreach ($images as $index => $image) : ?>
                    <div class="tab-pane <?php echo $index === 0 ? 'active' : ''; ?>"
                      id="pic-<?php echo $index + 1; ?>"
                      role="tabpanel"
                      aria-labelledby="tab<?php echo $index + 1; ?>">
                      <img class="img-fluid mx-auto" src="<?php echo esc_url($image); ?>" alt="Feature Tool Image <?php echo $index + 1; ?>" />
                    </div>
                  <?php endforeach; ?>
                <?php else : ?>
                  <div class="tab-pane active">
                    <p>No image available.</p>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-5 product_details pt-4 pt-sm-3">
          <h3 class="product-title"><?php the_title(); ?></h3>
          <div class="rating">
            <div class="stars">
              <?php for ($i = 1; $i <= 5; $i++) : ?>
                <span class="fa fa-star <?php echo ($i <= $rating) ? 'checked' : ''; ?>"></span>
              <?php endfor; ?>
            </div>
            <span class="review-no"><?php echo esc_html($votes); ?> reviews</span>
          </div>
          <p class="product-description"><?php the_content(); ?></p>
          <p class="vote">
            <strong><?php echo esc_html($votes_percent); ?>%</strong> of buyers enjoyed this product!
            <strong>(<?php echo esc_html($votes); ?> votes)</strong>
          </p>
        </div>
      </div>
    </div>
  </div>
</section>

<section class="reviews py-5 py-sm-3">
  <div class="container">
    <div class="row reviews_row">
      <div class="col-xs-9 col-lg-8 m-auto">
        <div class="carousel_btns">
          <button type="button" data-bs-target="#carouselDemo" data-bs-slide-to="0" class="btn btn-light active me-4">
            Product Details
          </button>
          <button type="button" data-bs-target="#carouselDemo" data-bs-slide-to="1" class="btn btn-light me-4">
            Warranty
          </button>
          <button type="button" data-bs-target="#carouselDemo" data-bs-slide-to="2" class="btn btn-light">
            Provider
          </button>
        </div>
        <hr>

        <div class="carousel slide" id="carouselDemo" data-bs-wrap="true">
          <div class="carousel-inner">
            <div class="carousel-item active">
              <blockquote>
                <div class="row">
                  <div class="col-auto mx-auto">
                    <p><?php echo esc_html(get_post_meta(get_the_ID(), 'product_details', true)); ?></p>
                  </div>
                </div>
              </blockquote>
            </div>

            <div class="carousel-item">
              <blockquote>
                <div class="row">
                  <div class="col-auto mx-auto">
                    <p><?php echo esc_html(get_post_meta(get_the_ID(), 'warranty', true)); ?></p>
                  </div>
                </div>
              </blockquote>
            </div>

            <div class="carousel-item">
              <blockquote>
                <div class="row">
                  <div class="col-auto mx-auto">
                    <p><?php echo esc_html(get_post_meta(get_the_ID(), 'provider', true)); ?></p>
                  </div>
                </div>
              </blockquote>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<section class="sec bg-light">
  <div class="container py-5 py-sm-3 sec_container">
    <div class="row mb-5">
      <div class="col-12 title_bx">
        <h3 class="title">Recent Feature Tools</h3>
      </div>
    </div>
    <div class="owl-listslide owl-carousel owl-theme">
      <?php
      $current_id = get_the_ID();
      $recent_tools = new WP_Query(array(
        'post_type'      => 'feature_tool',
        'posts_per_page' => 6,
        'post__not_in'   => array($current_id),
        'orderby'        => 'date',
        'order'          => 'DESC',
      ));

      if ($recent_tools->have_posts()) :
        while ($recent_tools->have_posts()) : $recent_tools->the_post();
      ?>
          <div class="list_item">
            <div class="sq_box shadow">
              <div class="pdis_img">
                <a href="<?php the_permalink(); ?>">
                  <?php if (has_post_thumbnail()) : ?>
                    <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), 'medium'); ?>" class="img-fluid" alt="<?php the_title(); ?>">
                  <?php else : ?>
                    <img src="https://via.placeholder.com/300" class="img-fluid" alt="No Image">
                  <?php endif; ?>
                </a>
                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
              </div>
            </div>
          </div>
      <?php
        endwhile;
        wp_reset_postdata();
      else :
        echo '<p>No recent feature tools found.</p>';
      endif;
      ?>
    </div>
  </div>
</section>

<?php get_footer(); ?>