<!-- <?php
      global $wp_query;
      echo '<pre>';
      print_r($wp_query->posts);
      echo '</pre>';
      ?> -->
<?php
// Template Name: Listing page
get_header()
?>
<?php
// call custom breadcrumbs
custom_breadcrumbs();
?>

<section class="light">
  <div class="container py-2">
    <h2 class="text-center text-dark listing_header fw-bold" id="pageHeaderTitle">All Listings</h2>
    <p class="listing_para pb-5 pt-4">Discover the best listings available in our directory.</p>

    <?php
    // Custom WP_Query to fetch 'listing' post type
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $args = array(
      'post_type'      => 'listing',
      'posts_per_page' => 10,
      'paged'          => $paged
    );
    $listing_query = new WP_Query($args);

    if ($listing_query->have_posts()) :
    ?>

      <div class="row cards_row justify-content-center gap-4">
        <?php while ($listing_query->have_posts()) : $listing_query->the_post(); ?>
          <div class="single_card col-12 col-sm-12 col-md-11 col-lg-10 py-4">
            <div class="row single_cars_row justify-content-center align-items-center">
              <div class="col-8 col-sm-4 card_image">
                <figure class="justify-content-center">
                  <?php if (has_post_thumbnail()) : ?>
                    <img src="<?php the_post_thumbnail_url('medium'); ?>" class="card-img-top" alt="<?php the_title(); ?>">
                  <?php else : ?>
                    <img src="https://via.placeholder.com/300x200" class="card-img-top" alt="Placeholder">
                  <?php endif; ?>
                </figure>
              </div>
              <div class="card_body col-12 col-sm-8 px-5">
                <div class="text-section">
                  <h3 class="card_title fw-bold pb-3"><?php the_title(); ?></h3>
                  <p class="card_text pb-3"><?php the_excerpt(); ?></p>
                </div>
                <div class="contact_section">
                  <div class="call_box pb-3">
                    <a href="tel:<?php echo get_post_meta(get_the_ID(), 'phone', true); ?>" class="pe-5">
                      <i class="fa-solid fa-phone pe-3"></i>
                      <?php echo get_post_meta(get_the_ID(), 'phone', true); ?>
                    </a>
                  </div>
                  <div class="email_box pb-3">
                    <a href="mailto:<?php echo get_post_meta(get_the_ID(), 'email', true); ?>">
                      <i class="fa-solid fa-envelope pe-3"></i>
                      <?php echo get_post_meta(get_the_ID(), 'email', true); ?>
                    </a>
                  </div>
                  <div class="website_link pb-3">
                    <a href="<?php echo esc_url(get_post_meta(get_the_ID(), 'website', true)); ?>" target="_blank">
                      <i class="fa-solid fa-globe pe-3"></i>
                      <?php echo get_post_meta(get_the_ID(), 'website', true); ?>
                    </a>
                  </div>
                  <div class="social_box pt-3 d-flex">
                    <a href="<?php echo esc_url(get_post_meta(get_the_ID(), 'facebook', true)); ?>"><i class="fa-brands fa-facebook"></i></a>
                    <a href="<?php echo esc_url(get_post_meta(get_the_ID(), 'instagram', true)); ?>"><i class="fa-brands fa-instagram"></i></a>
                    <a href="<?php echo esc_url(get_post_meta(get_the_ID(), 'linkedin', true)); ?>"><i class="fa-brands fa-linkedin-in"></i></a>
                    <a href="<?php echo esc_url(get_post_meta(get_the_ID(), 'twitter', true)); ?>"><i class="fa-brands fa-x-twitter"></i></a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        <?php endwhile; ?>
      </div>

      <!-- Pagination -->
      <div class="pagination">
        <?php
        echo paginate_links(array(
          'total' => $listing_query->max_num_pages,
          'current' => max(1, get_query_var('paged')),
          'prev_text' => __('« Previous', 'textdomain'),
          'next_text' => __('Next »', 'textdomain'),
        ));
        ?>
      </div>


    <?php else : ?>
      <p class="text-center text-muted">No listings available at the moment. Please check back later.</p>
    <?php endif; ?>

  </div>
</section>

<?php
wp_reset_postdata();
get_footer();
?>




<!-- 3️⃣ Prevent Empty Meta Fields From Displaying
Currently, if a listing has no phone, email, or website, an empty anchor tag (<a>) will still appear.
Fix this by checking if the meta field exists before displaying it.

Fix:

php
Copy
Edit
<?php $phone = get_post_meta(get_the_ID(), 'phone', true); ?>
<?php if (!empty($phone)) : ?>
  <div class="call_box pb-3">
    <a href="tel:<?php echo esc_attr($phone); ?>" class="pe-5">
      <i class="fa-solid fa-phone pe-3"></i> <?php echo esc_html($phone); ?>
    </a>
  </div>
<?php endif; ?>
Do this for all meta fields (email, website, social links).
 -->