<?php
/* Template Name: Feature Tools */

get_header(); ?>
<?php
// call custom breadcrumbs
custom_breadcrumbs();
?>
<section id="featuretools" class="py-5">
  <div class="container">
    <h2 class="featuretools_heading fw-bold text-center">Feature Tools</h2>
    <p class="featuretools_para text-center col-12 col-sm-10 col-lg-8 mx-auto pb-5 pt-4">
      Discover the best feature tools available for your needs.
    </p>

    <div class="row tools_row align-items-center justify-content-center">
      <?php
      $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
      $args = array(
        'post_type'      => 'feature_tool',
        'posts_per_page' => 10,
        'paged'          => $paged
      );
      $feature_tools = new WP_Query($args);

      if ($feature_tools->have_posts()) :
        while ($feature_tools->have_posts()) : $feature_tools->the_post();
          $image = get_post_meta(get_the_ID(), 'feature_tool_images', true);
          $image_url = !empty($image) ? esc_url($image[0]) : 'path/to/default-image.jpg';
      ?>
          <div class="col-12 col-sm-6 col-md-4 col-lg-3 mb-4">
            <div class="tools_card">
              <figure>
                <img src="<?php echo $image_url; ?>" alt="<?php the_title(); ?>">
              </figure>
              <h4 class="tools_heading"><?php the_title(); ?></h4>
              <p class="tools_para"><?php echo wp_trim_words(get_the_excerpt(), 15, '...'); ?></p>
              <div class="tools_btn">
                <a href="<?php the_permalink(); ?>" class="btn hvr-sweep-to-right">Know More</a>
              </div>
            </div>
          </div>
        <?php endwhile; ?>
    </div>

    <!-- Pagination -->
    <div class="pagination text-center mt-4">
      <?php
        echo paginate_links(array(
          'total'   => $feature_tools->max_num_pages,
          'current' => $paged,
          'prev_text' => __('« Prev'),
          'next_text' => __('Next »'),
        ));
      ?>
    </div>

  <?php else : ?>
    <p class="text-center">No feature tools found.</p>
  <?php endif;
      wp_reset_postdata(); ?>
  </div>
</section>

<?php get_footer(); ?>