<?php
/* Template Name: Blogs Page */
get_header();
// call custom breadcrumbs
custom_breadcrumbs();
?>
<section class="blog-listing gray-bg py-5">
  <div class="container">
    <h2 class="blog_page_heading text-center fw-bold">
      Dive into Our Articles
    </h2>
    <div class="row align-items-start pt-4">
      <div class="col-12 m-15 px-tb">
        <div class="row">
          <?php
          $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
          $args = array(
            'post_type'      => 'post',
            'posts_per_page' => 10,
            'paged'          => $paged
          );
          $query = new WP_Query($args);

          if ($query->have_posts()) :
            while ($query->have_posts()) : $query->the_post();
              $author_id = get_the_author_meta('ID');
          ?>
              <div class="col-md-4 row_card">
                <div class="blog-grid">
                  <div class="blog-img">
                    <div class="date">
                      <span class="text-center"><?php echo get_the_date('d'); ?></span>
                      <label><?php echo get_the_date('M'); ?></label>
                      <label><?php echo get_the_date('y'); ?></label>
                    </div>
                    <figure>
                      <a href="<?php the_permalink(); ?>">
                        <?php the_post_thumbnail('medium'); ?>
                      </a>
                    </figure>
                  </div>
                  <div class="blog_author align-items-center">
                    <figure>
                      <?php echo get_avatar($author_id, 50); ?>
                    </figure>
                    <h5><?php the_author(); ?></h5>
                  </div>
                  <div class="blog-info">
                    <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                    <p><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
                    <div class="btn-bar">
                      <a href="<?php the_permalink(); ?>" class="px-btn-arrow hvr-icon-forward">
                        Read More <i class="fa-solid fa-arrow-right hvr-icon"></i>
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            <?php endwhile; ?>
        </div>

        <div class="pagination">
          <?php
            echo paginate_links(array(
              'total'   => $query->max_num_pages,
              'current' => $paged,
              'prev_text' => __('&laquo; Previous'),
              'next_text' => __('Next &raquo;'),
            ));
          ?>
        </div>

        <?php wp_reset_postdata(); ?>
      <?php else : ?>
        <p class="text-center">No posts found.</p>
      <?php endif; ?>
      </div>
    </div>
  </div>
</section>

<?php get_footer(); ?>