<?php
// wp-content/themes/fitshight/header.php
?>
<!DOCTYPE html>
<html lang="<?php echo get_bloginfo('language'); ?>">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>The Fitshight</title>
  <?php wp_head(); ?>
</head>

<body>
  <?php wp_body_open(); ?>
  <!-- Navbar section start -->

  <nav id="nav_bar" class="navbar navbar-expand-lg fixed-top bg-light navbar-light">
    <div class="container">
      <a class="navbar-brand" href="<?php echo home_url(); ?>">
        <?php
        if (has_custom_logo()) {
          the_custom_logo();
        } else { ?>
          <img src="<?php echo get_template_directory_uri(); ?>/assets/images/logo-no-background.png" width="210" height="50" alt="Logo">
        <?php } ?>
      </a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
        aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <i class="fas fa-bars"></i>
      </button>

      <div class="collapse navbar-collapse" id="navbarSupportedContent">
        <?php
        wp_nav_menu(array(
          'theme_location'  => 'primary_menu',
          'depth'           => 2,
          'container'       => false,
          'menu_class'      => 'navbar-nav ms-auto align-items-center nav_wrapper',
          'fallback_cb'     => 'WP_Bootstrap_Navwalker::fallback',
          'walker'          => new Fitshight_Bootstrap_Navwalker()
        ));
        ?>

        <!-- Custom Buttons (Login/Logout) -->
        <ul class="navbar-nav ms-3">
          <?php if (is_user_logged_in()) : ?>
            <li class="nav-item">
              <a class="btn btn-black btn-rounded hvr-sweep-to-right" href="<?php echo wp_logout_url(home_url()); ?>">Log Out</a>
            </li>
          <?php else : ?>
            <li class="nav-item">
              <a class="btn btn-black btn-rounded hvr-sweep-to-right" data-bs-toggle="modal" data-bs-target="#myModal" href="#">Login</a>
            </li>
          <?php endif; ?>
        </ul>
      </div>
    </div>
  </nav>


  <div class="modal signin_modal fade" id="myModal" role="dialog">
    <div class="modal-dialog">

      <!-- Modal content-->
      <div class="modal-content">
        <div id="container" class="modal_container">
          <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">�</button>
          <div class="row justify-content-center wrapper pb-4" id="login-box">
            <div class="col-lg-11 my-auto myShadow">
              <div class="row modal_row">
                <div class="col-lg-7 bg-white p-4">
                  <h4 class="text-center font-weight-bold text-primary">Sign in to Account</h4>
                  <hr class="my-3">
                  <form action="#" method="post" class="px-3 d-flex flex-column gap-4" id="login-form">
                    <div class="input-group input-group-lg form-group">
                      <input type="email" id="email" name="email" class="form-control rounded-2" placeholder="E-Mail" required="">
                    </div>
                    <div class="input-group input-group-lg form-group">
                      <input type="password" id="password" name="password" class="form-control rounded-2" minlength="5" placeholder="Password" required="" autocomplete="off">
                    </div>
                    <div class="form-group clearfix">
                      <div class="custom-control custom-checkbox float-left">
                        <input type="checkbox" class="custom-control-input" id="customCheck" name="rem">
                        <label class="custom-control-label" for="customCheck">Remember me</label>
                      </div>
                      <div class="forgot float-right">
                        <a href="#" id="forgot-link">Forgot Password?</a>
                      </div>
                    </div>
                    <div class="form-group">
                      <input type="submit" id="login-btn" value="Sign In" class="btn btn-primary btn-lg btn-block myBtn">
                    </div>
                  </form>
                </div>
                <div class="col-lg-5 d-flex flex-column justify-content-center myColor p-4">
                  <h4 class="text-center font-weight-bold text-white">Hello Friends!</h4>
                  <hr class="my-3 bg-light myHr">
                  <p class="text-center font-weight-bolder text-light lead">Enter your personal details
                    and start your journey with us!</p>
                  <button class="btn btn-outline-light btn-lg align-self-center font-weight-bolder mt-4 myLinkBtn" id="register-link">Sign Up</button>
                </div>
              </div>
            </div>
          </div>
          <!-- Login Form End -->
          <!-- Registration Form Start -->
          <div class="row justify-content-center wrapper pb-4" id="register-box" style="display: none;">
            <div class="col-lg-11 my-auto myShadow">
              <div class="row">
                <div class="col-lg-5 d-flex flex-column justify-content-center myColor p-4">
                  <h4 class="text-center font-weight-bold text-white">Welcome Back!</h4>
                  <hr class="my-4 bg-light myHr">
                  <p class="text-center font-weight-bolder text-light lead">To keep connected with us
                    please login with your personal info.</p>
                  <button class="btn btn-outline-light btn-lg font-weight-bolder mt-4 align-self-center myLinkBtn" id="login-link">Sign In</button>
                </div>
                <div class="col-lg-7 bg-white p-4">
                  <h4 class="text-center font-weight-bold text-primary">Create Account</h4>
                  <hr class="my-3">
                  <form action="#" method="post" class="px-3 d-flex flex-column gap-4" id="register-form">
                    <div class="input-group input-group-lg form-group">
                      <input type="text" id="name" name="name" class="form-control rounded-2" placeholder="Full Name" required="">
                    </div>
                    <div class="input-group input-group-lg form-group">
                      <input type="email" id="remail" name="email" class="form-control rounded-2" placeholder="E-Mail" required="">
                    </div>
                    <div class="input-group input-group-lg form-group">
                      <input type="password" id="rpassword" name="password" class="form-control rounded-2" minlength="5" placeholder="Password" required="">
                    </div>
                    <div class="input-group input-group-lg form-group">
                      <input type="password" id="cpassword" name="cpassword" class="form-control rounded-2" minlength="5" placeholder="Confirm Password" required="">
                    </div>
                    <div class="form-group">
                      <div id="passError" class="text-danger font-weight-bolder"></div>
                    </div>
                    <div class="form-group">
                      <input type="submit" id="register-btn" value="Sign Up" class="btn btn-primary btn-lg btn-block myBtn">
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <!-- Registration Form End -->
          <!-- Upload Form Start -->
          <div class="row justify-content-center wrapper pb-4" id="upload-box" style="display: none;">
            <div class="col-lg-11 my-auto myShadow">
              <div class="row upload_row">
                <div class="col-lg-12 d-flex flex-column justify-content-center myColor p-4">
                  <h2 class="text-center font-weight-bold text-white">Welcome Admin</h2>
                  <hr class="my-2 bg-light myHr">
                  <p class="text-center font-weight-bolder text-light lead mb-0">Upload Your Business Information to Get Listed</p>
                </div>
                <div class="col-lg-12 bg-white p-4">
                  <h4 class="text-center font-weight-bold text-primary">Upload Details</h4>
                  <hr class="my-3">
                  <form action="#" method="post" class="px-3 d-flex flex-column gap-3" id="upload-form">
                    <div class="input-group input-group-lg form-group">
                      <input type="text" id="name" name="name" class="form-control rounded-2" placeholder="Company Name">
                    </div>
                    <div class="input-group input-group-lg form-group">
                      <input type="text" id="owner-name" name="owner-name" class="form-control rounded-2" placeholder="Owner Name">
                    </div>
                    <div class="input-group input-group-lg form-group">
                      <div class="row w-100 m-auto justify-content-between">
                        <div class="topinput col-6 p-0">
                          <input type="email" id="remail" name="email" class="form-control rounded-2" placeholder="Company e-Mail">
                        </div>
                        <div class="bottominput col-5 p-0">
                          <input type="file" id="company-file" name="company-file" class=" col-lg-5 form-control rounded-2" accept=".pdf,.doc,.docx,.jpg,.png">
                        </div>
                      </div>
                    </div>
                    <div class="input-group input-group-lg form-group">
                      <div class="row w-100 m-auto justify-content-between">
                        <div class="topinput col-6 p-0 pe-1">
                          <input type="tel" id="phnumber" name="phnumber" class="form-control rounded-2" placeholder="Ph. Number">
                        </div>
                        <div class="bottominput col-6 p-0 ps-1">
                          <input type="tel" id="opnumber" name="opnumber" class="form-control rounded-2" placeholder="Second Number">
                        </div>
                      </div>
                    </div>
                    <div class="input-group input-group-lg form-group">
                      <input type="text" id="address" name="address" class="form-control rounded-2" placeholder="Address">
                    </div>
                    <div class="input-group input-group-lg form-group">
                      <div class="row w-100 m-auto justify-content-between">
                        <div class="topinput col-6 p-0 pe-1">
                          <input type="text" id="city" name="city" class="form-control rounded-2" placeholder="City">
                        </div>
                        <div class="bottominput col-6 p-0 pe-1">
                          <input type="text" id="province" name="province" class="form-control rounded-2" placeholder="Province">
                        </div>
                      </div>
                    </div>
                    <div class="input-group input-group-lg form-group">
                      <div class="row w-100 m-auto justify-content-between">
                        <div class="topinput col-6 p-0 pe-1">
                          <input type="text" id="zip-code" name="zip-code" class="form-control rounded-2" placeholder="Zip Code" required="">
                        </div>
                        <div class="bottominput col-6 p-0 pe-1">
                          <input type="url" id="website" name="website" class="form-control rounded-2" placeholder="https://www.example.com">
                        </div>
                      </div>
                    </div>
                    <!-- <div class="form-group">
                                            <div id="passError" class="text-danger font-weight-bolder"></div>
                                        </div> -->
                    <div class="form-group">
                      <input type="submit" id="upload-btn" value="Submit" class="btn btn-primary btn-lg btn-block myBtn">
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
          <!-- Upload Form End -->
          <!-- Forgot Password Form Start -->
          <div class="row justify-content-center wrapper pb-4" id="forgot-box" style="display: none;">
            <div class="col-lg-11 my-auto myShadow">
              <div class="row">
                <div class="col-lg-7 bg-white p-4">
                  <h3 class="text-center font-weight-bold text-primary">Forgot Your Password?</h3>
                  <hr class="my-3">
                  <p class="lead text-center text-secondary">To reset your password, enter the registered
                    e-mail adddress and we will send you password reset instructions on your e-mail!</p>
                  <form action="#" method="post" class="px-3 d-flex flex-column gap-4" id="forgot-form">
                    <div id="forgotAlert"></div>
                    <div class="input-group input-group-lg form-group">
                      <input type="email" id="femail" name="email" class="form-control rounded-2" placeholder="E-Mail" required="">
                    </div>
                    <div class="form-group">
                      <input type="submit" id="forgot-btn" value="Reset Password" class="btn btn-primary btn-lg btn-block myBtn">
                    </div>
                  </form>
                </div>
                <div class="col-lg-5 d-flex flex-column justify-content-center myColor p-4">
                  <h4 class="text-center font-weight-bold text-white">Reset Password!</h4>
                  <hr class="my-4 bg-light myHr">
                  <button class="btn btn-outline-light btn-lg font-weight-bolder myLinkBtn align-self-center" id="back-link">Back</button>
                </div>
              </div>
            </div>
          </div>
          <!-- Forgot Password Form End -->
        </div>

      </div>
    </div>
  </div>


  <!-- Navbar section end -->