<?php
function fitshight_theme_setup()
{
  // Register navigation menus
  register_nav_menus(array(
    'primary_menu' => __('Primary Menu', 'fitshight'),
    'footer_menu'  => __('Footer Menu', 'fitshight')
  ));

  // Add theme support features
  add_theme_support('title-tag');
  add_theme_support('post-thumbnails');
}
add_action('after_setup_theme', 'fitshight_theme_setup');

// Enqueue styles and scripts
function fitshight_enqueue_assets()
{
  // CSS Files
  wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css', array(), null, 'all');
  wp_enqueue_style('font-awesome', get_template_directory_uri() . '/assets/css/all.min.css', array(), null, 'all');
  wp_enqueue_style('hover', get_template_directory_uri() . '/assets/css/hover.css', array(), null, 'all');
  wp_enqueue_style('owl-carousel', get_template_directory_uri() . '/assets/css/owl.carousel.min.css', array(), null, 'all');
  wp_enqueue_style('owl-theme', get_template_directory_uri() . '/assets/css/owl.theme.default.min.css', array(), null, 'all');
  wp_enqueue_style('main-style', get_template_directory_uri() . '/assets/css/style.css', array(), null, 'all');
  wp_enqueue_style('responsive-style', get_template_directory_uri() . '/assets/css/responssive.css', array(), null, 'all');

  // JS Files

  wp_enqueue_script('popper', get_template_directory_uri() . '/assets/js/popper.min.js', array('jquery'), null, true);
  wp_enqueue_script('bootstrap-bundle', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array('jquery', 'popper'), null, true);
  wp_enqueue_script('owl-carousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array('jquery'), null, true);
  wp_enqueue_script('app-script', get_template_directory_uri() . '/assets/js/app.js', array('jquery'), null, true);
  // wp_enqueue_script('custom-js', get_template_directory_uri() . '/assets/js/custom.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'fitshight_enqueue_assets');
// add_action('wp_footer', function () {
//   global $wp_scripts;
//   echo '<pre>';
//   print_r($wp_scripts->queue);
//   echo '</pre>';
// });
// Bootstrap Navwalker
require_once get_template_directory() . '/inc/class-bootstrap-navwalker.php';

//side-details file import
require_once get_template_directory() . '/site-details.php';


// Enable support for custom logo
function fitshight_custom_logo_setup()
{
  add_theme_support('custom-logo', array(
    'height' => 50,
    'width' => 210,
    'flex-height' => true,
    'flex-width' => true,
  ));
}
add_action('after_setup_theme', 'fitshight_custom_logo_setup');

/* -----------------------------------
 *  Admin Panel CSS & JS (For Editing Home Page)
 * ----------------------------------- */
function mytheme_enqueue_admin_assets($hook)
{
  global $post;

  if ($hook !== 'post.php' && $hook !== 'post-new.php') {
    return;
  }

  if ($post->post_type !== 'page') {
    return;
  }

  // Enqueue Admin CSS & JS
  wp_enqueue_media();
  wp_enqueue_style('mytheme-admin-css', get_template_directory_uri() . '/assets/css/admin.css', array(), null, 'all');
  wp_enqueue_script('mytheme-admin-js', get_template_directory_uri() . '/assets/js/admin.js', array('jquery'), null, true);

  // Pass PHP variables to JavaScript
  wp_localize_script('mytheme-admin-js', 'theme_admin_vars', array(
    'default_hero_image' => get_template_directory_uri() . '/assets/images/default-hero.jpg'
  ));
}
add_action('admin_enqueue_scripts', 'mytheme_enqueue_admin_assets');

// Register Custom Post Type for Feature Tools
// 1️⃣ Register Custom Post Type: Feature Tools
// 1️⃣ Register Custom Post Type: Feature Tools
function create_feature_tool_post_type()
{
  $labels = array(
    'name'          => 'Feature Tools',
    'singular_name' => 'Feature Tool',
    'menu_name'     => 'Feature Tools',
    'add_new'       => 'Add New Tool',
    'add_new_item'  => 'Add New Feature Tool',
    'edit_item'     => 'Edit Feature Tool',
    'new_item'      => 'New Feature Tool',
    'view_item'     => 'View Feature Tool',
    'all_items'     => 'All Feature Tools',
  );

  $args = array(
    'labels'        => $labels,
    'public'        => true,
    'supports'      => array('title', 'editor', 'thumbnail'),
    'menu_position' => 5,
    'menu_icon'     => 'dashicons-admin-tools',
    'has_archive'   => true,
    'show_in_rest'  => true,
  );

  register_post_type('feature_tool', $args);
}
add_action('init', 'create_feature_tool_post_type');

// 2️⃣ Add Meta Box
function add_feature_tool_meta_box()
{
  add_meta_box(
    'feature_tool_meta',
    'Feature Tool Details',
    'render_feature_tool_meta_box',
    'feature_tool',
    'normal',
    'high'
  );
}
add_action('add_meta_boxes', 'add_feature_tool_meta_box');

// 3️⃣ Render Meta Box
function render_feature_tool_meta_box($post)
{
  $images = get_post_meta($post->ID, 'feature_tool_images', true) ?: [];
  $rating = get_post_meta($post->ID, 'feature_tool_rating', true);
  $votes_percent = get_post_meta($post->ID, 'feature_tool_votes_percent', true);
  $votes = get_post_meta($post->ID, 'feature_tool_votes', true);
  $product_details = get_post_meta($post->ID, 'product_details', true);
  $warranty = get_post_meta($post->ID, 'warranty', true);
  $provider = get_post_meta($post->ID, 'provider', true);

  wp_nonce_field('save_feature_tool_details', 'feature_tool_nonce');
?>
  <p><strong>Upload Feature Tool Images (Max: 6)</strong></p>
  <div id="feature_images_container">
    <?php foreach ($images as $image) : ?>
      <div class="feature-image-preview">
        <img src="<?php echo esc_url($image); ?>" width="100" />
        <input type="hidden" name="feature_images[]" value="<?php echo esc_url($image); ?>">
        <button type="button" class="remove-image">Remove</button>
      </div>
    <?php endforeach; ?>
  </div>
  <button id="upload_feature_images" type="button" class="button">Upload Images</button>

  <p><strong>Star Rating (1-5):</strong></p>
  <input type="number" name="feature_tool_rating" min="1" max="5" step="1"
    value="<?php echo esc_attr($rating); ?>"
    oninput="this.value = Math.min(5, Math.max(1, this.value))">


  <p><strong>Voting Percentage:</strong></p>
  <input type="number" name="feature_tool_votes_percent" min="0" max="100" value="<?php echo esc_attr($votes_percent); ?>"> %

  <p><strong>Total Votes:</strong></p>
  <input type="number" name="feature_tool_votes" value="<?php echo esc_attr($votes); ?>">

  <p><label for="product_details"><strong>Product Details:</strong></label></p>
  <textarea id="product_details" name="product_details" rows="4" style="width:100%;"><?php echo esc_textarea($product_details); ?></textarea>

  <p><label for="warranty"><strong>Warranty:</strong></label></p>
  <textarea id="warranty" name="warranty" rows="4" style="width:100%;"><?php echo esc_textarea($warranty); ?></textarea>

  <p><label for="provider"><strong>Provider:</strong></label></p>
  <textarea id="provider" name="provider" rows="4" style="width:100%;"><?php echo esc_textarea($provider); ?></textarea>

  <script>
    jQuery(document).ready(function($) {
      $('#upload_feature_images').click(function(e) {
        e.preventDefault();
        var imageFrame = wp.media({
          title: 'Select or Upload Images',
          button: {
            text: 'Use Images'
          },
          multiple: true
        });

        imageFrame.on('select', function() {
          var selection = imageFrame.state().get('selection');
          var images = [];
          selection.each(function(attachment) {
            images.push(attachment.toJSON().url);
          });

          if ($('#feature_images_container .feature-image-preview').length + images.length > 6) {
            alert('You can upload a maximum of 6 images.');
            return;
          }

          images.forEach(function(image) {
            $('#feature_images_container').append(
              `<div class="feature-image-preview">
                              <img src="${image}" width="100">
                              <input type="hidden" name="feature_images[]" value="${image}">
                              <button type="button" class="remove-image">Remove</button>
                          </div>`
            );
          });
        });
        imageFrame.open();
      });

      $(document).on('click', '.remove-image', function() {
        $(this).parent().remove();
      });
    });
  </script>
<?php
}

// 4️⃣ Save Meta Box Data
function save_feature_tool_meta_data($post_id)
{
  if (!isset($_POST['feature_tool_nonce']) || !wp_verify_nonce($_POST['feature_tool_nonce'], 'save_feature_tool_details')) return;
  if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

  if (isset($_POST['feature_images'])) {
    update_post_meta($post_id, 'feature_tool_images', array_map('esc_url', $_POST['feature_images']));
  }
  $rating = isset($_POST['feature_tool_rating']) ? intval($_POST['feature_tool_rating']) : 1;
  $rating = ($rating < 1) ? 1 : (($rating > 5) ? 5 : $rating);
  update_post_meta($post_id, 'feature_tool_rating', $rating);
  update_post_meta($post_id, 'feature_tool_votes_percent', sanitize_text_field($_POST['feature_tool_votes_percent'] ?? 0));
  update_post_meta($post_id, 'feature_tool_votes', sanitize_text_field($_POST['feature_tool_votes'] ?? 0));
  update_post_meta($post_id, 'product_details', sanitize_textarea_field($_POST['product_details'] ?? ''));
  update_post_meta($post_id, 'warranty', sanitize_textarea_field($_POST['warranty'] ?? ''));
  update_post_meta($post_id, 'provider', sanitize_textarea_field($_POST['provider'] ?? ''));
}
add_action('save_post', 'save_feature_tool_meta_data');

// ✅ Enable Pagination
function feature_tools_pagination($query)
{
  if (!is_admin() && $query->is_main_query() && is_post_type_archive('feature_tool')) {
    $query->set('posts_per_page', 10);
  }
}
add_action('pre_get_posts', 'feature_tools_pagination');

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//5555555555555555555555555555555__________DYNAMIC BREADCRUMBS________5555555555555555555555555555
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// Function to generate dynamic breadcrumbs
function custom_breadcrumbs()
{
  if (is_front_page()) return; // Don't show breadcrumbs on the homepage

  echo '<main id="page_top_banner">
          <div class="page_topbanner_text">
              <h1>' . get_the_title() . '</h1>
              <h5><span><a href="' . home_url() . '">Home</a>';

  if (is_singular('feature_tool')) {
    echo ' >> <a href="' . get_post_type_archive_link('feature_tool') . '">Feature Tools</a> >> ' . get_the_title();
  } elseif (is_single()) {
    echo ' >> Blog >> ' . get_the_title();
  } elseif (is_page()) {
    echo ' >> ' . get_the_title();
  } elseif (is_archive()) {
    echo ' >> ' . post_type_archive_title('', false);
  }

  echo '</span></h5></div></main>';
}
// code for listing page
function custom_listing_post_type()
{
  $labels = array(
    'name'               => __('Listings', 'textdomain'),
    'singular_name'      => __('Listing', 'textdomain'),
    'menu_name'          => __('Listings', 'textdomain'),
    'name_admin_bar'     => __('Listing', 'textdomain'), // Changes "Add New Post" to "Add New Listing"
    'add_new'            => __('Add New Listing', 'textdomain'),
    'add_new_item'       => __('Add New Listing', 'textdomain'),
    'new_item'           => __('New Listing', 'textdomain'),
    'edit_item'          => __('Edit Listing', 'textdomain'),
    'view_item'          => __('View Listing', 'textdomain'),
    'all_items'          => __('All Listings', 'textdomain'),
    'search_items'       => __('Search Listings', 'textdomain'),
    'not_found'          => __('No listings found.', 'textdomain'),
    'not_found_in_trash' => __('No listings found in Trash.', 'textdomain')
  );

  $args = array(
    'labels'             => $labels,
    'public'             => true,
    'has_archive'        => false,
    'show_ui'            => true,
    'menu_position'      => 5,
    'menu_icon'          => 'dashicons-businessman',
    'supports'           => array('title', 'editor', 'thumbnail'),
    'rewrite'            => array('slug' => 'listing'),
  );

  register_post_type('listing', $args);
}
add_action('init', 'custom_listing_post_type');

// Register the meta box for listing details
function add_listing_meta_box()
{
  add_meta_box(
    'listing_details_meta_box', // Meta Box ID
    'Listing Details', // Title in the admin panel
    'listing_meta_callback', // Callback function to display the fields
    'listing', // Post type
    'normal', // Context (where it appears)
    'high' // Priority (higher appears first)
  );
}
add_action('add_meta_boxes', 'add_listing_meta_box');

// Callback function to display meta fields
function listing_meta_callback($post)
{
  $values = get_post_meta($post->ID);

?>
  <p>
    <label for="phone">Phone Number:</label><br>
    <input type="text" id="phone" name="phone" value="<?php echo esc_attr($values['phone'][0] ?? ''); ?>" size="50">
  </p>
  <p>
    <label for="email">Email:</label><br>
    <input type="email" id="email" name="email" value="<?php echo esc_attr($values['email'][0] ?? ''); ?>" size="50">
  </p>
  <p>
    <label for="website">Website:</label><br>
    <input type="url" id="website" name="website" value="<?php echo esc_attr($values['website'][0] ?? ''); ?>" size="50">
  </p>
  <h4>Social Media Links</h4>
  <p>
    <label for="facebook">Facebook:</label><br>
    <input type="url" id="facebook" name="facebook" value="<?php echo esc_attr($values['facebook'][0] ?? ''); ?>" size="50">
  </p>
  <p>
    <label for="instagram">Instagram:</label><br>
    <input type="url" id="instagram" name="instagram" value="<?php echo esc_attr($values['instagram'][0] ?? ''); ?>" size="50">
  </p>
  <p>
    <label for="linkedin">LinkedIn:</label><br>
    <input type="url" id="linkedin" name="linkedin" value="<?php echo esc_attr($values['linkedin'][0] ?? ''); ?>" size="50">
  </p>
  <p>
    <label for="twitter">Twitter:</label><br>
    <input type="url" id="twitter" name="twitter" value="<?php echo esc_attr($values['twitter'][0] ?? ''); ?>" size="50">
  </p>
<?php
}

// Save Meta Box Data
function save_listing_meta_data($post_id)
{
  $fields = ['phone', 'email', 'website', 'facebook', 'instagram', 'linkedin', 'twitter'];

  foreach ($fields as $field) {
    if (isset($_POST[$field])) {
      update_post_meta($post_id, $field, sanitize_text_field($_POST[$field]));
    }
  }
}
add_action('save_post', 'save_listing_meta_data');


// home page func. / front-paage.php
// getting all section separate button


// ✅ Add Meta Boxes only for the Home Page
function mytheme_add_home_page_meta_boxes()
{
  $screen = get_current_screen();
  if ($screen->id === 'page' && get_option('page_on_front') == get_the_ID()) {
    add_meta_box('home_hero_section', 'Hero Section', 'mytheme_home_hero_section_callback', 'page', 'normal', 'default');
  }
}
add_action('add_meta_boxes', 'mytheme_add_home_page_meta_boxes');

// ✅ Hero Section Meta Box Callback
function mytheme_home_hero_section_callback($post)
{
  $hero_title = get_post_meta($post->ID, '_hero_title', true);
  $hero_description = get_post_meta($post->ID, '_hero_description', true);
  $hero_button_text = get_post_meta($post->ID, '_hero_button_text', true);
  $hero_button_url = get_post_meta($post->ID, '_hero_button_url', true);
  $hero_bg_image = get_post_meta($post->ID, '_hero_bg_image', true);

  // Nonce for security
  wp_nonce_field('mytheme_home_meta_nonce_action', 'mytheme_home_meta_nonce');
?>
  <p><label for="hero_title"><strong>Hero Title:</strong></label></p>
  <input type="text" id="hero_title" name="hero_title" value="<?php echo esc_attr($hero_title); ?>" class="widefat">

  <p><label for="hero_description"><strong>Hero Description:</strong></label></p>
  <textarea id="hero_description" name="hero_description" rows="3" class="widefat"><?php echo esc_textarea($hero_description); ?></textarea>

  <p><label for="hero_button_text"><strong>Button Text:</strong></label></p>
  <input type="text" id="hero_button_text" name="hero_button_text" value="<?php echo esc_attr($hero_button_text); ?>" class="widefat">

  <p><label for="hero_button_url"><strong>Button URL:</strong></label></p>
  <input type="url" id="hero_button_url" name="hero_button_url" value="<?php echo esc_url($hero_button_url); ?>" class="widefat">

  <p><label for="hero_bg_image"><strong>Hero Background Image:</strong></label></p>
  <input type="text" id="hero_bg_image" name="hero_bg_image" value="<?php echo esc_url($hero_bg_image); ?>" class="widefat">
  <button class="button hero_bg_image_upload">Upload Image</button>
  <button class="button hero_bg_image_remove">Remove Image</button>
  <br><br>
  <img id="hero_bg_image_preview" src="<?php echo esc_url($hero_bg_image ? $hero_bg_image : get_template_directory_uri() . '/assets/images/default-hero.jpg'); ?>" style="max-width: 100%; height: auto;">
<?php
}

// ✅ Save Meta Box Data
function mytheme_save_home_meta_boxes($post_id)
{
  // Security checks
  if (!isset($_POST['mytheme_home_meta_nonce']) || !wp_verify_nonce($_POST['mytheme_home_meta_nonce'], 'mytheme_home_meta_nonce_action')) {
    return;
  }
  if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
    return;
  }
  if (!current_user_can('edit_page', $post_id)) {
    return;
  }

  // ✅ Save Meta Fields
  update_post_meta($post_id, '_hero_title', sanitize_text_field($_POST['hero_title']));
  update_post_meta($post_id, '_hero_description', sanitize_textarea_field($_POST['hero_description']));
  update_post_meta($post_id, '_hero_button_text', sanitize_text_field($_POST['hero_button_text']));
  update_post_meta($post_id, '_hero_button_url', esc_url($_POST['hero_button_url']));
  update_post_meta($post_id, '_hero_bg_image', esc_url($_POST['hero_bg_image']));
}
add_action('save_post', 'mytheme_save_home_meta_boxes');

// ✅ Enqueue JavaScript for Media Uploader
function mytheme_enqueue_admin_scripts($hook)
{
  if ($hook === 'post.php' || $hook === 'post-new.php') {
    wp_enqueue_media();
    wp_enqueue_script('mytheme-admin-script', get_template_directory_uri() . '/assets/js/admin.js', array('jquery'), null, true);
  }
}
add_action('admin_enqueue_scripts', 'mytheme_enqueue_admin_scripts');


// $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
// $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

// ✅ Add Meta Box for Feature Tools Section in Home Page
function mytheme_add_home_feature_tools_meta_box()
{
  $screen = get_current_screen();
  if ($screen->id === 'page' && get_option('page_on_front') == get_the_ID()) {
    add_meta_box('home_feature_tools_section', 'Feature Tools Section', 'mytheme_home_feature_tools_section_callback', 'page', 'normal', 'default');
  }
}
add_action('add_meta_boxes', 'mytheme_add_home_feature_tools_meta_box');

// ✅ Meta Box Callback Function (Dashboard)
function mytheme_home_feature_tools_section_callback($post)
{
  $show_feature_tools = get_post_meta($post->ID, '_show_feature_tools', true);
  $feature_tools_heading = get_post_meta($post->ID, '_feature_tools_heading', true);
  $feature_tools_description = get_post_meta($post->ID, '_feature_tools_description', true);

  wp_nonce_field('mytheme_home_meta_nonce_action', 'mytheme_home_meta_nonce');
?>
  <p>
    <input type="checkbox" id="show_feature_tools" name="show_feature_tools" value="1" <?php checked($show_feature_tools, '1'); ?>>
    <label for="show_feature_tools"><strong>Enable Feature Tools Section</strong></label>
  </p>

  <p><label for="feature_tools_heading"><strong>Feature Tools Heading:</strong></label></p>
  <input type="text" id="feature_tools_heading" name="feature_tools_heading" value="<?php echo esc_attr($feature_tools_heading); ?>" class="widefat">

  <p><label for="feature_tools_description"><strong>Feature Tools Description:</strong></label></p>
  <textarea id="feature_tools_description" name="feature_tools_description" rows="3" class="widefat"><?php echo esc_textarea($feature_tools_description); ?></textarea>
<?php
}

// ✅ Save Meta Box Data
function mytheme_save_home_feature_tools_meta_boxes($post_id)
{
  if (!isset($_POST['mytheme_home_meta_nonce']) || !wp_verify_nonce($_POST['mytheme_home_meta_nonce'], 'mytheme_home_meta_nonce_action')) {
    return;
  }
  if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
    return;
  }
  if (!current_user_can('edit_page', $post_id)) {
    return;
  }

  update_post_meta($post_id, '_show_feature_tools', isset($_POST['show_feature_tools']) ? '1' : '0');
  update_post_meta($post_id, '_feature_tools_heading', sanitize_text_field($_POST['feature_tools_heading']));
  update_post_meta($post_id, '_feature_tools_description', sanitize_textarea_field($_POST['feature_tools_description']));
}
add_action('save_post', 'mytheme_save_home_feature_tools_meta_boxes');

// %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

// ✅ Add Meta Box for Listings Section in Home Page
function mytheme_add_home_listings_meta_box()
{
  $screen = get_current_screen();
  if ($screen->id === 'page' && get_option('page_on_front') == get_the_ID()) {
    add_meta_box('home_listings_section', 'Listings Section', 'mytheme_home_listings_section_callback', 'page', 'normal', 'default');
  }
}
add_action('add_meta_boxes', 'mytheme_add_home_listings_meta_box');

// ✅ Meta Box Callback Function (Dashboard)
function mytheme_home_listings_section_callback($post)
{
  $show_listings = get_post_meta($post->ID, '_show_listings', true);
  $listings_heading = get_post_meta($post->ID, '_listings_heading', true);
  $listings_description = get_post_meta($post->ID, '_listings_description', true);

  wp_nonce_field('mytheme_home_meta_nonce_action', 'mytheme_home_meta_nonce');
?>
  <p>
    <input type="checkbox" id="show_listings" name="show_listings" value="1" <?php checked($show_listings, '1'); ?>>
    <label for="show_listings"><strong>Enable Listings Section</strong></label>
  </p>

  <p><label for="listings_heading"><strong>Listings Section Heading:</strong></label></p>
  <input type="text" id="listings_heading" name="listings_heading" value="<?php echo esc_attr($listings_heading); ?>" class="widefat">

  <p><label for="listings_description"><strong>Listings Section Description:</strong></label></p>
  <textarea id="listings_description" name="listings_description" rows="3" class="widefat"><?php echo esc_textarea($listings_description); ?></textarea>
<?php
}

// ✅ Save Meta Box Data
function mytheme_save_home_listings_meta_boxes($post_id)
{
  if (!isset($_POST['mytheme_home_meta_nonce']) || !wp_verify_nonce($_POST['mytheme_home_meta_nonce'], 'mytheme_home_meta_nonce_action')) {
    return;
  }
  if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
    return;
  }
  if (!current_user_can('edit_page', $post_id)) {
    return;
  }

  update_post_meta($post_id, '_show_listings', isset($_POST['show_listings']) ? '1' : '0');
  update_post_meta($post_id, '_listings_heading', sanitize_text_field($_POST['listings_heading']));
  update_post_meta($post_id, '_listings_description', sanitize_textarea_field($_POST['listings_description']));
}
add_action('save_post', 'mytheme_save_home_listings_meta_boxes');


// ✅ Add Meta Box for Blog Section in Home Page
function mytheme_add_home_blog_meta_box()
{
  $screen = get_current_screen();
  if ($screen->id === 'page' && get_option('page_on_front') == get_the_ID()) {
    add_meta_box('home_blog_section', 'Blog Section', 'mytheme_home_blog_section_callback', 'page', 'normal', 'default');
  }
}
add_action('add_meta_boxes', 'mytheme_add_home_blog_meta_box');

// ✅ Meta Box Callback Function (Dashboard)
function mytheme_home_blog_section_callback($post)
{
  $show_blog_section = get_post_meta($post->ID, '_show_blog_section', true);
  $blog_heading = get_post_meta($post->ID, '_blog_heading', true);
  $blog_description = get_post_meta($post->ID, '_blog_description', true);

  wp_nonce_field('mytheme_home_blog_nonce_action', 'mytheme_home_blog_nonce');
?>
  <p>
    <input type="checkbox" id="show_blog_section" name="show_blog_section" value="1" <?php checked($show_blog_section, '1'); ?>>
    <label for="show_blog_section"><strong>Enable Blog Section</strong></label>
  </p>

  <p><label for="blog_heading"><strong>Blog Section Heading:</strong></label></p>
  <input type="text" id="blog_heading" name="blog_heading" value="<?php echo esc_attr($blog_heading); ?>" class="widefat">

  <p><label for="blog_description"><strong>Blog Section Description:</strong></label></p>
  <textarea id="blog_description" name="blog_description" rows="3" class="widefat"><?php echo esc_textarea($blog_description); ?></textarea>
<?php
}

// ✅ Save Meta Box Data
function mytheme_save_home_blog_meta_boxes($post_id)
{
  if (!isset($_POST['mytheme_home_blog_nonce']) || !wp_verify_nonce($_POST['mytheme_home_blog_nonce'], 'mytheme_home_blog_nonce_action')) {
    return;
  }
  if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
    return;
  }
  if (!current_user_can('edit_page', $post_id)) {
    return;
  }

  update_post_meta($post_id, '_show_blog_section', isset($_POST['show_blog_section']) ? '1' : '0');
  update_post_meta($post_id, '_blog_heading', sanitize_text_field($_POST['blog_heading']));
  update_post_meta($post_id, '_blog_description', sanitize_textarea_field($_POST['blog_description']));
}
add_action('save_post', 'mytheme_save_home_blog_meta_boxes');

// SITE DETAILS

// Add Admin Menu for Company Settings
function company_settings_page()
{
  add_menu_page(
    'Company Details',
    'Company Details',
    'manage_options',
    'company-details',
    'company_settings_page_html',
    'dashicons-building',
    20
  );
}
add_action('admin_menu', 'company_settings_page');

// Display the settings page HTML
function company_settings_page_html()
{
?>
  <div class="wrap">
    <h1>Company Details</h1>
    <form method="post" action="options.php">
      <?php
      settings_fields('company_details_group');
      do_settings_sections('company-details');
      submit_button();
      ?>
    </form>
  </div>
<?php
}

// Register settings fields
function company_register_settings()
{
  $fields = [
    'company_name'     => 'Company Name',
    'company_phone'    => 'Phone Number',
    'company_email'    => 'Email Address',
    'company_location' => 'Location',
    'company_fax'      => 'Fax Number',
    'company_short_note' => 'Short Note About Company' // ✅ New Field Added
  ];

  foreach ($fields as $key => $label) {
    register_setting('company_details_group', $key);
    add_settings_section('company_section', '', null, 'company-details');
    add_settings_field($key, $label, function () use ($key) {
      $value = get_option($key, '');
      echo '<input type="text" name="' . esc_attr($key) . '" value="' . esc_attr($value) . '" />';
    }, 'company-details', 'company_section');
  }

  // ✅ Register logo upload fields for header and footer
  register_setting('company_details_group', 'company_header_logo');
  register_setting('company_details_group', 'company_footer_logo');

  add_settings_field('company_header_logo', 'Header Logo', 'company_logo_upload_field', 'company-details', 'company_section', ['logo_key' => 'company_header_logo']);
  add_settings_field('company_footer_logo', 'Footer Logo', 'company_logo_upload_field', 'company-details', 'company_section', ['logo_key' => 'company_footer_logo']);
}
add_action('admin_init', 'company_register_settings');

// ✅ Function for logo upload field
function company_logo_upload_field($args)
{
  $logo_key = $args['logo_key'];
  $logo = get_option($logo_key, '');
  echo '<input type="text" id="' . esc_attr($logo_key) . '" name="' . esc_attr($logo_key) . '" value="' . esc_url($logo) . '" />';
  echo '<button type="button" class="upload_logo_button button" data-target="' . esc_attr($logo_key) . '">Upload Logo</button>';
  if ($logo) {
    echo '<br><img src="' . esc_url($logo) . '" style="max-width:150px;margin-top:10px;" />';
  }
}

// ✅ Enqueue admin.js script for logo upload
function company_admin_scripts($hook)
{
  if ($hook !== 'toplevel_page_company-details') {
    return;
  }
  wp_enqueue_media();
  wp_enqueue_script('admin-scripts', get_template_directory_uri() . '/assets/js/admin.js', ['jquery'], null, true);
}
add_action('admin_enqueue_scripts', 'company_admin_scripts');
