<?php get_header(); ?>

<!-- Herobanner section start -->

<?php
$hero_title = get_post_meta(get_the_ID(), '_hero_title', true);
$hero_description = get_post_meta(get_the_ID(), '_hero_description', true);
$hero_button_text = get_post_meta(get_the_ID(), '_hero_button_text', true);
$hero_button_url = get_post_meta(get_the_ID(), '_hero_button_url', true);
$hero_bg_image = get_post_meta(get_the_ID(), '_hero_bg_image', true);

// Set default background image if none is set
$hero_bg_image = !empty($hero_bg_image) ? esc_url($hero_bg_image) : get_template_directory_uri() . '/assets/images/default-hero.jpg';
?>

<main id="herobanner" style="background-image: url('<?php echo $hero_bg_image; ?>'); background-size: cover; background-position: center;">
  <div class="container">
    <h1 class="text-center text-white"><?php echo esc_html($hero_title ? $hero_title : 'Find what you need!'); ?></h1>
    <p class="text-light text-center">
      <?php echo esc_html($hero_description ? $hero_description : 'Lorem ipsum dolor sit amet, consectetur adipisicing elit.'); ?>
    </p>
    <?php if ($hero_button_text && $hero_button_url) : ?>
      <div class="sbuscribe_button d-flex justify-content-center">
        <a class="btn btn-black btn-rounded hvr-sweep-to-right hvr-icon-forward" href="<?php echo esc_url($hero_button_url); ?>">
          <?php echo esc_html($hero_button_text); ?> &nbsp;<i class="fa-solid fa-right-to-bracket hvr-icon"></i>
        </a>
      </div>
    <?php endif; ?>
  </div>
</main>

<!-- herobanner section end -->

<!-- Features section start -->
<?php
$show_feature_tools = get_post_meta(get_the_ID(), '_show_feature_tools', true);
$feature_tools_heading = get_post_meta(get_the_ID(), '_feature_tools_heading', true);
$feature_tools_description = get_post_meta(get_the_ID(), '_feature_tools_description', true);

if ($show_feature_tools) : ?>
  <section id="features" class="container_padding">
    <div class="professional_bottom container">
      <h2 class="feature_heading text-center fw-bold">
        <?php echo esc_html($feature_tools_heading ? $feature_tools_heading : 'Our Features'); ?>
      </h2>
      <p class="feature_para text-center">
        <?php echo esc_html($feature_tools_description ? $feature_tools_description : 'Discover the amazing tools we offer.'); ?>
      </p>
      <div class="testimonial">
        <?php
        $args = array(
          'post_type' => 'feature_tool',
          'posts_per_page' => -1
        );
        $feature_query = new WP_Query($args);
        if ($feature_query->have_posts()) : ?>
          <div class="owl-one owl-carousel owl-theme">
            <?php while ($feature_query->have_posts()) : $feature_query->the_post();
              $feature_image = get_the_post_thumbnail_url(get_the_ID(), 'full');
              $feature_title = get_the_title();
              $feature_excerpt = get_the_excerpt();
              $feature_link = get_permalink();
            ?>
              <div class="item">
                <div class="item_img__box">
                  <img src="<?php echo esc_url($feature_image); ?>" alt="<?php echo esc_attr($feature_title); ?>" />
                </div>
                <h4><?php echo esc_html($feature_title); ?></h4>
                <p><?php echo esc_html($feature_excerpt); ?></p>
                <div class="item_box__btn">
                  <a class="btn btn-black btn-rounded hvr-sweep-to-right" href="<?php echo esc_url($feature_link); ?>">Read More</a>
                </div>
              </div>
            <?php endwhile; ?>
          </div>
        <?php else : ?>
          <p class="text-center">No feature tools available at the moment. Please check back later.</p>
        <?php endif;
        wp_reset_postdata(); ?>
      </div>
    </div>
  </section>
<?php endif; ?>
<!-- <section id="features" class="container_padding">
  <div class="professional_bottom container">
    <h2 class="feature_heading text-center fw-bold">Our Features</h2>
    <p class="feature_para text-center">Lorem ipsum dolor sit amet consectetur adipisicing elit. Laboriosam, vel
      recusandae? Obcaecati a blanditiis quaerat consectetur reiciendis pariatur, ullam, ratione dignissimos
      dolores debitis beatae quae.</p>
    <div class="testimonial">
      <div class="owl-one owl-carousel owl-theme">
        <div class="item">
          <div class="item_img__box">
            <img src="images/landscap-g-1.jpg" alt="">
          </div>
          <h4>JOINT MOBILIZATION</h4>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Iure,
            sapiente! Dolore veniam numquam non earum ipsum excepturi
            voluptatum cumque expedita.
          </p>
          <div class="item_box__btn">
            <div class="item_box__btn">
              <a class="btn btn-black btn-rounded hvr-sweep-to-right" href="./featureToolDetails.html">Read More</a>
            </div>
          </div>
        </div>
        <div class="item">
          <div class="item_img__box">
            <img src="images/landscap-g-2.jpg" alt="">
          </div>
          <h4>JOINT MOBILIZATION</h4>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Iure,
            sapiente! Dolore veniam numquam non earum ipsum excepturi
            voluptatum cumque expedita.
          </p>
          <div class="item_box__btn">
            <div class="item_box__btn">
              <a class="btn btn-black btn-rounded hvr-sweep-to-right" href="./featureToolDetails.html">Read More</a>
            </div>
          </div>
        </div>
        <div class="item">
          <div class="item_img__box">
            <img src="images/landscap-g-3.jpg" alt="">
          </div>
          <h4>JOINT MOBILIZATION</h4>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Iure,
            sapiente! Dolore veniam numquam non earum ipsum excepturi
            voluptatum cumque expedita.
          </p>
          <div class="item_box__btn">
            <a class="btn btn-black btn-rounded hvr-sweep-to-right" href="./featureToolDetails.html">Read More</a>
          </div>
        </div>
        <div class="item">
          <div class="item_img__box">
            <img src="images/landscap-g-4.jpg" alt="">
          </div>

          <h4>JOINT MOBILIZATION</h4>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Iure,
            sapiente! Dolore veniam numquam non earum ipsum excepturi
            voluptatum cumque expedita.
          </p>
          <div class="item_box__btn">
            <a class="btn btn-black btn-rounded hvr-sweep-to-right" href="./featureToolDetails.html">Read More</a>
          </div>
        </div>
        <div class="item">
          <div class="item_img__box">
            <img src="images/landscap-g-5.jpg" alt="">
          </div>
          <h4>JOINT MOBILIZATION</h4>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Iure,
            sapiente! Dolore veniam numquam non earum ipsum excepturi
            voluptatum cumque expedita.
          </p>
          <div class="item_box__btn">
            <a class="btn btn-black btn-rounded hvr-sweep-to-right" href="./featureToolDetails.html">Read More</a>
          </div>
        </div>
        <div class="item">
          <div class="item_img__box">
            <img src="images/landscap-g-2.jpg" alt="">
          </div>
          <h4>JOINT MOBILIZATION</h4>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Iure,
            sapiente! Dolore veniam numquam non earum ipsum excepturi
            voluptatum cumque expedita.
          </p>
          <div class="item_box__btn">
            <a class="btn btn-black btn-rounded hvr-sweep-to-right" href="./featureToolDetails.html">Read More</a>
          </div>
        </div>
        <div class="item">
          <div class="item_img__box">
            <img src="images/landscap-g-3.jpg" alt="">
          </div>
          <h4>JOINT MOBILIZATION</h4>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Iure,
            sapiente! Dolore veniam numquam non earum ipsum excepturi
            voluptatum cumque expedita.
          </p>
          <div class="item_box__btn">
            <a class="btn btn-black btn-rounded hvr-sweep-to-right" href="./featureToolDetails.html">Read More</a>
          </div>
        </div>
        <div class="item">
          <div class="item_img__box">
            <img src="images/landscap-g-4.jpg" alt="">
          </div>
          <h4>JOINT MOBILIZATION</h4>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Iure,
            sapiente! Dolore veniam numquam non earum ipsum excepturi
            voluptatum cumque expedita.
          </p>
          <div class="item_box__btn">
            <a class="btn btn-black btn-rounded hvr-sweep-to-right" href="./featureToolDetails.html">Read More</a>
          </div>
        </div>
        <div class="item">
          <div class="item_img__box">
            <img src="images/landscap-g-5.jpg" alt="">
          </div>
          <h4>JOINT MOBILIZATION</h4>
          <p>
            Lorem ipsum dolor sit amet consectetur adipisicing elit. Iure,
            sapiente! Dolore veniam numquam non earum ipsum excepturi
            voluptatum cumque expedita.
          </p>
          <div class="item_box__btn">
            <a class="btn btn-black btn-rounded hvr-sweep-to-right" href="./featureToolDetails.html">Read More</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section> -->

<!-- Features section end -->

<!-- listing  section start -->

<?php
$show_listings = get_post_meta(get_the_ID(), '_show_listings', true);
$listings_heading = get_post_meta(get_the_ID(), '_listings_heading', true);
$listings_description = get_post_meta(get_the_ID(), '_listings_description', true);

if ($show_listings) : ?>
  <section id="professional_banner">
    <div class="container">
      <div class="professional_top">
        <h2><?php echo esc_html($listings_heading ? $listings_heading : 'Our Featured Partners List'); ?></h2>
        <p><?php echo esc_html($listings_description ? $listings_description : 'Find the best partners available for you.'); ?></p>
      </div>
      <div class="professional_bottom">
        <div class="testimonial">
          <?php
          $args = array(
            'post_type'      => 'listing',
            'posts_per_page' => -1
          );
          $listing_query = new WP_Query($args);

          if ($listing_query->have_posts()) : ?>
            <div class="owl-demo-2 owl-carousel owl-theme">
              <?php while ($listing_query->have_posts()) : $listing_query->the_post();
                $listing_image  = get_the_post_thumbnail_url(get_the_ID(), 'full');
                $listing_title  = get_the_title();
                $listing_phone  = get_post_meta(get_the_ID(), 'phone', true);
                $listing_email  = get_post_meta(get_the_ID(), 'email', true);
                $listing_website = get_post_meta(get_the_ID(), 'website', true);
              ?>
                <div class="item">
                  <div class="item_img__box">
                    <img src="<?php echo esc_url($listing_image ? $listing_image : get_template_directory_uri() . '/assets/images/default-placeholder.png'); ?>" alt="<?php echo esc_attr($listing_title); ?>" />
                  </div>
                  <h4 class="company_name"><?php echo esc_html($listing_title); ?></h4>
                  <div class="item_contact_box">
                    <div class="phone_box justify-content-center">
                      <?php if ($listing_phone) : ?>
                        <a href="tel:<?php echo esc_attr($listing_phone); ?>"><i class="fa-solid fa-phone"></i> <?php echo esc_html($listing_phone); ?></a>
                      <?php else : ?>
                        <a href="#"><i class="fa-solid fa-phone"></i> Contacts not available</a>
                      <?php endif; ?>
                    </div>

                    <div class="mail_box">
                      <?php if ($listing_email) : ?>
                        <a href="mailto:<?php echo esc_attr($listing_email); ?>"><i class="fa-solid fa-envelope"></i> <?php echo esc_html($listing_email); ?></a>
                      <?php else : ?>
                        <i class="fa-solid fa-envelope"></i> No email available
                      <?php endif; ?>
                    </div>

                    <div class="website_box">
                      <?php if ($listing_website) : ?>
                        <a href="<?php echo esc_url($listing_website); ?>"><i class="fa-solid fa-globe"></i> <?php echo esc_html($listing_website); ?></a>
                      <?php else : ?>
                        <i class="fa-solid fa-globe"></i> No website available
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              <?php endwhile; ?>
            </div>
          <?php else : ?>
            <p class="no-listings-message text-center"><strong>No listings available at the moment.</strong></p>
          <?php endif;
          wp_reset_postdata(); ?>
        </div>
      </div>
    </div>
  </section>
<?php endif; ?>

<!-- <section id="professional_banner">
  <div class="container">
    <div class="professional_top">
      <h2>Our Featured Partners list</h2>
      <p>
        Lorem ipsum dolor sit amet consectetur adipisicing elit. Sit eos
        quaerat quod, modi ullam blanditiis, harum totam ex error, dolore
        aliquid mollitia! Voluptatem, esse voluptatum.
      </p>
    </div>
    <div class="professional_bottom">
      <div class="testimonial">
        <div class="owl-demo-2 owl-carousel owl-theme">
          <div class="item">
            <div class="item_img__box">
              <img src="images/landscap-g-3.jpg" alt="">
            </div>
            <h4 class="company_name">JOINT MOBILIZATION corporation private limited</h4>
            <div class="item_contact_box">
              <div class="phone_box justify-content-center">
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
                <a href="tel: +01-234-567-88"> +01 234 567 88</a>
              </div>
              <div class="mail_box">
                <a href="mailto: info@mailtodemo.ca"><i class="fa-solid fa-envelope"></i>
                  info@info@mailtodemo.ca</a>
              </div>
              <div class="website_box">
                <a href="#"><i class="fa-solid fa-globe"></i>thefitshight.ca</a>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="item_img__box">
              <img src="images/landscap-g-3.jpg" alt="">
            </div>
            <h4 class="company_name">JOINT MOBILIZATION corporation private limited</h4>
            <div class="item_contact_box">
              <div class="phone_box justify-content-center">
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
              </div>
              <div class="mail_box">
                <a href="mailto: info@mailtodemo.ca"><i class="fa-solid fa-envelope"></i>
                  info@info@mailtodemo.ca</a>
              </div>
              <div class="website_box">
                <a href="#"><i class="fa-solid fa-globe"></i>thefitshight.ca</a>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="item_img__box">
              <img src="images/landscap-g-3.jpg" alt="">
            </div>
            <h4 class="company_name">JOINT MOBILIZATION corporation private limited</h4>
            <div class="item_contact_box">
              <div class="phone_box justify-content-center">
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
              </div>
              <div class="mail_box">
                <a href="mailto: info@mailtodemo.ca"><i class="fa-solid fa-envelope"></i>
                  info@info@mailtodemo.ca</a>
              </div>
              <div class="website_box">
                <a href="#"><i class="fa-solid fa-globe"></i>thefitshight.ca</a>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="item_img__box">
              <img src="images/landscap-g-3.jpg" alt="">
            </div>
            <h4 class="company_name">JOINT MOBILIZATION corporation private limited</h4>
            <div class="item_contact_box">
              <div class="phone_box justify-content-center">
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
              </div>
              <div class="mail_box">
                <a href="mailto: info@mailtodemo.ca"><i class="fa-solid fa-envelope"></i>
                  info@info@mailtodemo.ca</a>
              </div>
              <div class="website_box">
                <a href="#"><i class="fa-solid fa-globe"></i>thefitshight.ca</a>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="item_img__box">
              <img src="images/landscap-g-3.jpg" alt="">
            </div>
            <h4 class="company_name">JOINT MOBILIZATION corporation private limited</h4>
            <div class="item_contact_box">
              <div class="phone_box justify-content-center">
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
              </div>
              <div class="mail_box">
                <a href="mailto: info@mailtodemo.ca"><i class="fa-solid fa-envelope"></i>
                  info@info@mailtodemo.ca</a>
              </div>
              <div class="website_box">
                <a href="#"><i class="fa-solid fa-globe"></i>thefitshight.ca</a>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="item_img__box">
              <img src="images/landscap-g-3.jpg" alt="">
            </div>
            <h4 class="company_name">JOINT MOBILIZATION corporation private limited</h4>
            <div class="item_contact_box">
              <div class="phone_box justify-content-center">
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
              </div>
              <div class="mail_box">
                <a href="mailto: info@mailtodemo.ca"><i class="fa-solid fa-envelope"></i>
                  info@info@mailtodemo.ca</a>
              </div>
              <div class="website_box">
                <a href="#"><i class="fa-solid fa-globe"></i>thefitshight.ca</a>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="item_img__box">
              <img src="images/landscap-g-3.jpg" alt="">
            </div>
            <h4 class="company_name">JOINT MOBILIZATION corporation private limited</h4>
            <div class="item_contact_box">
              <div class="phone_box justify-content-center">
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
              </div>
              <div class="mail_box">
                <a href="mailto: info@mailtodemo.ca"><i class="fa-solid fa-envelope"></i>
                  info@info@mailtodemo.ca</a>
              </div>
              <div class="website_box">
                <a href="#"><i class="fa-solid fa-globe"></i>thefitshight.ca</a>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="item_img__box">
              <img src="images/landscap-g-3.jpg" alt="">
            </div>
            <h4 class="company_name">JOINT MOBILIZATION corporation private limited</h4>
            <div class="item_contact_box">
              <div class="phone_box justify-content-center">
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
              </div>
              <div class="mail_box">
                <a href="mailto: info@mailtodemo.ca"><i class="fa-solid fa-envelope"></i>
                  info@info@mailtodemo.ca</a>
              </div>
              <div class="website_box">
                <a href="#"><i class="fa-solid fa-globe"></i>thefitshight.ca</a>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="item_img__box">
              <img src="images/landscap-g-3.jpg" alt="">
            </div>
            <h4 class="company_name">JOINT MOBILIZATION corporation private limited</h4>
            <div class="item_contact_box">
              <div class="phone_box justify-content-center">
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
              </div>
              <div class="mail_box">
                <a href="mailto: info@mailtodemo.ca"><i class="fa-solid fa-envelope"></i>
                  info@info@mailtodemo.ca</a>
              </div>
              <div class="website_box">
                <a href="#"><i class="fa-solid fa-globe"></i>thefitshight.ca</a>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="item_img__box">
              <img src="images/landscap-g-3.jpg" alt="">
            </div>
            <h4 class="company_name">JOINT MOBILIZATION corporation private limited</h4>
            <div class="item_contact_box">
              <div class="phone_box justify-content-center">
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
              </div>
              <div class="mail_box">
                <a href="mailto: info@mailtodemo.ca"><i class="fa-solid fa-envelope"></i>
                  info@info@mailtodemo.ca</a>
              </div>
              <div class="website_box">
                <a href="#"><i class="fa-solid fa-globe"></i>thefitshight.ca</a>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="item_img__box">
              <img src="images/landscap-g-3.jpg" alt="">
            </div>
            <h4 class="company_name">JOINT MOBILIZATION corporation private limited</h4>
            <div class="item_contact_box">
              <div class="phone_box justify-content-center">
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
              </div>
              <div class="mail_box">
                <a href="mailto: info@mailtodemo.ca"><i class="fa-solid fa-envelope"></i>
                  info@info@mailtodemo.ca</a>
              </div>
              <div class="website_box">
                <a href="#"><i class="fa-solid fa-globe"></i>thefitshight.ca</a>
              </div>
            </div>
          </div>
          <div class="item">
            <div class="item_img__box">
              <img src="images/landscap-g-3.jpg" alt="">
            </div>
            <h4 class="company_name">JOINT MOBILIZATION corporation private limited</h4>
            <div class="item_contact_box">
              <div class="phone_box justify-content-center">
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
                <a href="tel: +01-234-567-88"><i class="fa-solid fa-phone"></i> +01 234 567 88</a>
              </div>
              <div class="mail_box">
                <a href="mailto: info@mailtodemo.ca"><i class="fa-solid fa-envelope"></i>
                  info@info@mailtodemo.ca</a>
              </div>
              <div class="website_box">
                <a href="#"><i class="fa-solid fa-globe"></i>thefitshight.ca</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section> -->
<!-- listing  section end -->

<!-- Blog section start -->
<?php
$show_blog_section = get_post_meta(get_the_ID(), '_show_blog_section', true);
$blog_heading = get_post_meta(get_the_ID(), '_blog_heading', true);
$blog_description = get_post_meta(get_the_ID(), '_blog_description', true);

if ($show_blog_section) : ?>
  <section id="blogslide" class="container_padding">
    <div class="container">
      <h2 class="blogslide_header text-center fw-bold">
        <?php echo esc_html($blog_heading ? $blog_heading : 'Welcome to Our Blog'); ?>
      </h2>
      <p class="blogslide_para text-center">
        <?php echo esc_html($blog_description ? $blog_description : 'Stay updated with our latest articles and insights.'); ?>
      </p>
      <div class="review_slider">
        <div class="testimonial_review">
          <div class="owl-two owl-carousel owl-theme">
            <?php
            $blog_args = array(
              'post_type'      => 'post',
              'posts_per_page' => 5,
            );
            $blog_query = new WP_Query($blog_args);

            if ($blog_query->have_posts()) :
              while ($blog_query->have_posts()) : $blog_query->the_post();
                $blog_image = get_the_post_thumbnail_url(get_the_ID(), 'medium');
                $blog_title = get_the_title();
                $blog_excerpt = wp_trim_words(get_the_excerpt(), 20);
                $blog_link = get_permalink();
            ?>
                <div class="review_item row align-items-center justify-content-center">
                  <div class="col-11">
                    <figure>
                      <a href="<?php echo esc_url($blog_link); ?>">
                        <img src="<?php echo esc_url($blog_image); ?>" alt="<?php echo esc_attr($blog_title); ?>" />
                      </a>
                    </figure>
                    <h3 class="text-center mb-3">
                      <a href="<?php echo esc_url($blog_link); ?>">
                        <?php echo esc_html($blog_title); ?>
                      </a>
                    </h3>
                    <div class="date_group my-2">
                      <span><i class="fa-solid fa-calendar-days"></i> <?php echo get_the_date(); ?></span>
                      <span class="admin"><i class="fa-solid fa-user-tie"></i> <?php the_author(); ?></span>
                    </div>
                    <p class="text-justify"><?php echo esc_html($blog_excerpt); ?></p>
                    <div class="blog_button d-flex justify-content-center">
                      <a class="btn btn-black btn-rounded hvr-sweep-to-right" href="<?php echo esc_url($blog_link); ?>">
                        Read More <i class="fa-solid fa-arrow-right"></i>
                      </a>
                    </div>
                  </div>
                </div>
            <?php endwhile;
            else : ?>
              <p class="text-center">No blog posts available at the moment. Check back later!</p>
            <?php endif;
            wp_reset_postdata(); ?>
          </div>
        </div>
      </div>
    </div>
  </section>
<?php endif; ?>
<!-- <section id="blogslide " class="container_padding">
  <div class="container">
    <h2 class="blogslide_header text-center fw-bold">
      Welcome to Our Blog
    </h2>
    <p class="blogslide_para text-center">
      Lorem ipsum dolor sit amet consectetur adipisicing elit. Officiis
      corrupti distinctio debitis recusandae dolorum ex quidem voluptatem
      consequuntur labore iusto, alias optio libero, quaerat consequatur!
    </p>
    <div class="review_slider">
      <div class="testimonial_review">
        <div class="owl-two owl-carousel owl-theme">
          <div
            class="review_item row align-items-center justify-content-center">
            <div class="col-11">
              <figure>
                <img src="images/landscap-g-2.jpg" alt="" />
              </figure>
              <h3 class="text-center mb-3">
                <a href="#">
                  How Physical Therapy Can Help Prevent Injuries In Youth
                  Sports
                </a>
              </h3>
              <div class="date_group my-2">
                <span><i class="fa-solid fa-calendar-days"></i> Sun May
                  26</span>
                <span class="admin"><i class="fa-solid fa-user-tie"></i> Admin</span>
              </div>
              <p class="text-justify">
                Lorem ipsum dolor sit amet consectetur adipisicing elit.
                Quibusdam asperiores eligendi odio provident! Molestias eos
                laudantium, natus possimus eveniet fugit praesentium, optio
                distinctio. asperiores eligendi odio provident! Molestias
                eos laudantium, natus possimus eveniet fugit praesentium,
                optio distinctio. asperiores eligendi odio provident!
                Molestias eos laudantium, natus possimus eveniet fugit
                praesentium, optio distinctio.
              </p>
              <div class="blog_button d-flex justify-content-center">
                <a
                  class="btn btn-black btn-rounded hvr-sweep-to-right"
                  href="#">Read More <i class="fa-solid fa-arrow-right"></i></a>
              </div>
            </div>
          </div>

          <div
            class="review_item row align-items-center justify-content-center">
            <div class="col-11">
              <figure>
                <img src="images/landscap-g-2.jpg" alt="" />
              </figure>
              <h3 class="text-center mb-3">
                <a href="#">
                  How Physical Therapy Can Help Prevent Injuries In Youth
                  Sports
                </a>
              </h3>
              <div class="date_group my-2">
                <span><i class="fa-solid fa-calendar-days"></i> Sun May
                  26</span>
                <span class="admin"><i class="fa-solid fa-user-tie"></i> Admin</span>
              </div>
              <p class="text-justify">
                Lorem ipsum dolor sit amet consectetur adipisicing elit.
                Quibusdam asperiores eligendi odio provident! Molestias eos
                laudantium, natus possimus eveniet fugit praesentium, optio
                distinctio. asperiores eligendi odio provident! Molestias
                eos laudantium, natus possimus eveniet fugit praesentium,
                optio distinctio. asperiores eligendi odio provident!
                Molestias eos laudantium, natus possimus eveniet fugit
                praesentium, optio distinctio.
              </p>
              <div class="blog_button d-flex justify-content-center">
                <a
                  class="btn btn-black btn-rounded hvr-sweep-to-right"
                  href="#">Read More <i class="fa-solid fa-arrow-right"></i></a>
              </div>
            </div>
          </div>

          <div
            class="review_item row align-items-center justify-content-center">
            <div class="col-11">
              <figure>
                <img src="images/landscap-g-2.jpg" alt="" />
              </figure>
              <h3 class="text-center mb-3">
                <a href="#">
                  How Physical Therapy Can Help Prevent Injuries In Youth
                  Sports
                </a>
              </h3>
              <div class="date_group my-2">
                <span><i class="fa-solid fa-calendar-days"></i> Sun May
                  26</span>
                <span class="admin"><i class="fa-solid fa-user-tie"></i> Admin</span>
              </div>
              <p class="text-justify">
                Lorem ipsum dolor sit amet consectetur adipisicing elit.
                Quibusdam asperiores eligendi odio provident! Molestias eos
                laudantium, natus possimus eveniet fugit praesentium, optio
                distinctio. asperiores eligendi odio provident! Molestias
                eos laudantium, natus possimus eveniet fugit praesentium,
                optio distinctio. asperiores eligendi odio provident!
                Molestias eos laudantium, natus possimus eveniet fugit
                praesentium, optio distinctio.
              </p>
              <div class="blog_button d-flex justify-content-center">
                <a
                  class="btn btn-black btn-rounded hvr-sweep-to-right"
                  href="#">Read More <i class="fa-solid fa-arrow-right"></i></a>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</section> -->
<!-- Blog section end -->
<?php get_footer(); ?>